#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <sys/timeb.h>

#include "bits.h"
#include "defs.h"

using namespace std;

typedef unsigned int uint32_t;

u64 clear_above[64];
u64 clear_below[64];
u64 rank_masks[8];
u64 file_masks[8];
u64 setter[64];
u64 clearer[64];

/** pawn masks for eval **/
u64 isfilenorth[64];//is a bit set north of our bit... e.g on E4, is something on E5, E6, E7, E8
u64 isfilesouth[64];
u64 isisolated[64];
u64 whitepassed[64];
u64 blackpassed[64];

const u64 all = 0xffffffffffffffffULL;
const u64 one = 1ULL;


void init_setter()
{
   for(int i = 0; i < 64; ++i)
   {
       setter[i] = 0;
       setter[i] |= (one<<i);
   }
}

void init_clearer()
{
   for(int i = 0; i < 64; ++i)
   {
       clearer[i] = 0;
       clearer[i] = ~(one<<i);
   }
}

void init_masks()
{
    u64 mask = 0xffULL;
    u64 temp = 0;
    uint f,r,tsq,sq;
    for( r = RANK1; r <= RANK8; ++r)
    {
       rank_masks[r] = 0;
       rank_masks[r] |= (mask<<r*8);
    }

    //set file masks
    mask = 0x101010101010101ULL;
    for( f = FILEA; f <= FILEH; ++f)
    {
        file_masks[f] = 0;
        file_masks[f] |= (mask<<f);
    }

    //set clearabove
    for( sq = 0; sq < 64; ++sq)
    {
        clear_above[sq] = all;
        for(tsq=sq+1; tsq < 64; ++tsq)
        {
            clear_above[sq] &= clearer[tsq];
        }
    }
    //set clearbelow
    for( sq = 0; sq < 64; ++sq)
    {
        clear_below[sq] = 0;
        for(tsq=sq+1; tsq < 64; ++tsq)
        {
            clear_below[sq] |= setter[tsq];
        }
    }

    //pawns - order of initialisation critical
    for( sq = 0; sq < 64; ++sq)
    {
        f = files[sqfrom64(sq)];
        temp = file_masks[f];
        temp &= clear_below[sq];
        temp &= clearer[sq];
        isfilenorth[sq] = temp;
    }

    for( sq = 0; sq < 64; ++sq)
    {
        f = files[sqfrom64(sq)];
        temp = file_masks[f];
        temp &= clear_above[sq];
        temp &= clearer[sq];
        isfilesouth[sq] = temp;
    }

    for( sq = 0; sq < 64; ++sq)
    {
        temp = 0ULL;
        f = files[sqfrom64(sq)];
        if(f>FILEA)
        temp |= file_masks[f-1];
        if(f<FILEH)
        temp |= file_masks[f+1];
        isisolated[sq] = temp;
    }

    for( sq = 0; sq < 64; ++sq)
    {
      temp = 0ULL;
      f = files[sqfrom64(sq)];
      r = ranks[sqfrom64(sq)];
      if(r==RANK1||r>=RANK7) continue;
      if(f>FILEA)
      temp |= isfilenorth[sq-1];
      if(f<FILEH)
      temp |= isfilenorth[sq+1];

      temp |= isfilenorth[sq];
      whitepassed[sq]=temp;
    }

    for( sq = 0; sq < 64; ++sq)
    {
      temp = 0ULL;
      f = files[sqfrom64(sq)];
      r = ranks[sqfrom64(sq)];
      if(r==RANK8||r<=RANK2) continue;
      if(f>FILEA)
      temp |= isfilesouth[sq-1];
      if(f<FILEH)
      temp |= isfilesouth[sq+1];

      temp |= isfilesouth[sq];
      blackpassed[sq]=temp;
    }
}

void init_bitboards()
{
    init_clearer();
    init_setter();//these two must be first
    init_masks();//also pawn eval masks here
}

static const int BitTable11[64] = {
  63, 30, 3, 32, 25, 41, 22, 33, 15, 50, 42, 13, 11, 53, 19, 34, 61, 29, 2,
  51, 21, 43, 45, 10, 18, 47, 1, 54, 9, 57, 0, 35, 62, 31, 40, 4, 49, 5, 52,
  26, 60, 6, 23, 44, 46, 27, 56, 16, 7, 39, 48, 24, 59, 14, 12, 55, 38, 28,
  58, 20, 37, 17, 36, 8
};


// first_1() finds the least significant nonzero bit in a nonzero bitboard.

int LSB(u64 b) {
  b ^= (b - 1);
  uint32_t fold = int(b) ^ int(b >> 32);
  return int(BitTable11[(fold * 0x783a9b23) >> 26]);
}


// pop_1st_bit() finds and clears the least significant nonzero bit in a
// nonzero bitboard.

int POP(u64 &b) {
  u64 bb = b ^ (b - 1);
  uint32_t fold = int(bb) ^ int(bb >> 32);
  b &= (b - 1);
  return int(BitTable11[(fold * 0x783a9b23) >> 26]);
}


const u64 s      =   0;
const u64 heik   = 457;
const u64 y      =   1;
const u64 e      =   2;
const u64 r      =   3;
const u64 b      =   4;
const u64 o      =   5;
const u64 u      =   8;
const u64 t      =  16;
const u64 i      =  32;
const u64     ka = (1<< 4)-1;
const u64   waka = (1<< 8)-1;
const u64 jawaka = (1<<16)-1;
const u64 jazzFromHell = 0-(16*3*heik);

int MSB(u64 all) {
   u64 so,fa;
   fa   = (u64)(all >> i);
   so   = (fa!=s)       << o;
   fa  ^= (u64) all & (fa!=s)-y;
   so  ^= (jawaka < fa) << b;
   fa >>= (jawaka < fa) << b;
   so  ^= (  waka - fa) >> t    & u;
   fa >>= (  waka - fa) >> t    & u;
   so  ^= (    ka - fa) >> u    & b;
   fa >>= (    ka - fa) >> u    & b;
   so  ^=  jazzFromHell >> e*fa & r;
   return (int)so;
}


void printbitboard(const u64 bitbrd)
{
    cout<<endl;
    for(int i = 0; i < 64; ++i)
    {
        if(i%8==0) cout<<endl;
        if(bitbrd&(one<<i)) cout<<"x";
        else cout<<"-";
    }
        cout<<endl;
}



